/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp;

import com.aptana.filesystem.secureftp.Messages;
import com.aptana.filesystem.secureftp.internal.SecureFTPPlugin;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.enterprisedt.net.puretls.LoadProviders;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.PreferenceInitializer;

public final class SecureUtils {
    private static final String[] EMPTY = new String[0];

    private SecureUtils() {
    }

    public static boolean isKeyPassphraseProtected(File keyFile) throws CoreException {
        try {
            LoadProviders.init();
            SshPrivateKeyFile privateKeyFile = SshPrivateKeyFile.parse((File)keyFile);
            return privateKeyFile.isPassphraseProtected();
        }
        catch (InvalidSshKeyException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SecureUtils_InvalidPrivateKey, keyFile.getAbsolutePath()), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.filesystem.secureftp", MessageFormat.format(Messages.SecureUtils_UnableToReadPrivateKey, keyFile.getAbsolutePath())));
        }
    }

    public static boolean isPassphraseValid(File keyFile, char[] password) {
        try {
            SshPrivateKeyFile.parse((File)keyFile).toPrivateKey(String.copyValueOf(password));
            return true;
        }
        catch (InvalidSshKeyException e) {
            if (e.getCause() instanceof NoSuchAlgorithmException) {
                SecureFTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.secureftp", e.getCause().getMessage()));
            }
        }
        catch (IOException ignore) {
            ignore.getCause();
        }
        return false;
    }

    public static String getSSH_HOME() {
        return Platform.getPreferencesService().getString(JSchCorePlugin.ID, "SSH2HOME", PreferenceInitializer.SSH_HOME_DEFAULT, null);
    }

    public static String[] getPrivateKeys() {
        String value = Platform.getPreferencesService().getString(JSchCorePlugin.ID, "PRIVATEKEY", "id_dsa,id_rsa", null);
        if (value != null && value.length() > 0) {
            return value.trim().split(",");
        }
        return EMPTY;
    }
}

